/*
 * Decompiled with CFR 0.152.
 */
package me.powns.directionhud.settings;

import java.awt.Color;
import java.io.File;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Settings {
    private boolean enabled = true;
    private boolean shadowedText = true;
    private boolean background = true;
    private boolean biomeName = true;
    private boolean direction = true;
    private boolean skinFaceDirection = true;
    private boolean showInChat;
    private boolean verticalMode = true;
    public int minX;
    public int minY;
    public int maxX;
    public int maxY;
    public int addX = 1;
    public int addY = 1;
    public int prefixColor = Integer.MAX_VALUE;
    public int textColor = Integer.MAX_VALUE;
    public int backgroundColor = 0x50000000;
    public int backgroundAlpha = 50;
    public int biomeNameColor = Integer.MAX_VALUE;
    public int directionColor = Integer.MAX_VALUE;
    public boolean textChroma;
    public boolean prefixChroma;
    public boolean backgroundChroma;
    public boolean biomeNameChroma;
    public boolean directionChroma;
    public int prefixStyle = 0;
    public int decimals = 0;
    public float scale = 1.0f;
    private File saveFile;

    public Settings() {
        this.saveFile = new File(Minecraft.func_71410_x().field_71412_D, "Powns Coords HUD/settings.config");
    }

    public DecimalFormat getFormat() {
        if (this.decimals == 0) {
            return new DecimalFormat("#");
        }
        String usedToFormat = "#.";
        for (int i = 0; i <= this.decimals; ++i) {
            usedToFormat = usedToFormat + "0";
        }
        return new DecimalFormat(usedToFormat);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isShadowedText() {
        return this.shadowedText;
    }

    public void setShadowedText(boolean shadowedText) {
        this.shadowedText = shadowedText;
    }

    public boolean isBiomeName() {
        return this.biomeName;
    }

    public void setBiomeName(boolean biomeName) {
        this.biomeName = biomeName;
    }

    public boolean isDirection() {
        return this.direction;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public boolean isSkinFaceDirection() {
        return this.skinFaceDirection;
    }

    public void setSkinFaceDirection(boolean skinFaceDirection) {
        this.skinFaceDirection = skinFaceDirection;
    }

    public boolean isShowInChat() {
        return this.showInChat;
    }

    public void setShowInChat(boolean showInChat) {
        this.showInChat = showInChat;
    }

    public boolean isVerticalMode() {
        return this.verticalMode;
    }

    public void setVerticalMode(boolean verticalMode) {
        this.verticalMode = verticalMode;
    }

    public int getPrefixColor() {
        return this.prefixChroma ? Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 0.8f, 0.8f) : this.prefixColor;
    }

    public int getTextColor() {
        return this.textChroma ? Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 0.8f, 0.8f) : this.textColor;
    }

    public int getBiomeNameColor() {
        return this.biomeNameChroma ? Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 0.8f, 0.8f) : this.biomeNameColor;
    }

    public int getDirectionColor() {
        return this.directionChroma ? Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 0.8f, 0.8f) : this.directionColor;
    }

    public int getBackgroundColor() {
        int rgb = this.backgroundColor;
        if (this.backgroundChroma) {
            rgb = Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 0.8f, 0.8f);
        }
        return this.getColorWithAlpha(rgb, this.backgroundAlpha);
    }

    private int getColorWithAlpha(int rgb, int a) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public void saveConfig() {
        Configuration config = new Configuration(this.saveFile);
        this.updateConfig(config, false);
        config.save();
    }

    public void loadConfig() {
        Configuration config = new Configuration(this.saveFile);
        config.load();
        this.updateConfig(config, true);
    }

    private void updateConfig(Configuration config, boolean load) {
        Property prop = config.get("General", "Enabled", true);
        if (load) {
            this.enabled = prop.getBoolean();
        } else {
            prop.setValue(this.enabled);
        }
        prop = config.get("General", "X", 1);
        if (load) {
            this.addX = prop.getInt();
        } else {
            prop.setValue(this.minX);
        }
        prop = config.get("General", "Y", 1);
        if (load) {
            this.addY = prop.getInt();
        } else {
            prop.setValue(this.minY);
        }
        prop = config.get("General", "ShowInChat", false);
        if (load) {
            this.showInChat = prop.getBoolean();
        } else {
            prop.setValue(this.showInChat);
        }
        prop = config.get("General", "Scale", 1.0);
        if (load) {
            this.scale = (float)prop.getDouble();
        } else {
            prop.setValue((double)this.scale);
        }
        prop = config.get("General", "Decimals", 0);
        if (load) {
            this.decimals = prop.getInt();
        } else {
            prop.setValue(this.decimals);
        }
        prop = config.get("General", "ShadowedText", true);
        if (load) {
            this.shadowedText = prop.getBoolean();
        } else {
            prop.setValue(this.shadowedText);
        }
        prop = config.get("General", "DirectionEnabled", true);
        if (load) {
            this.direction = prop.getBoolean();
        } else {
            prop.setValue(this.direction);
        }
        prop = config.get("General", "BiomeEnabled", true);
        if (load) {
            this.biomeName = prop.getBoolean();
        } else {
            prop.setValue(this.biomeName);
        }
        prop = config.get("General", "VerticalMode", true);
        if (load) {
            this.verticalMode = prop.getBoolean();
        } else {
            prop.setValue(this.verticalMode);
        }
        prop = config.get("Background", "Chroma", false);
        if (load) {
            this.backgroundChroma = prop.getBoolean();
        } else {
            prop.setValue(this.backgroundChroma);
        }
        prop = config.get("Background", "Color", 0x50000000);
        if (load) {
            this.backgroundColor = prop.getInt();
        } else {
            prop.setValue(this.backgroundColor);
        }
        prop = config.get("Background", "Alpha", 50);
        if (load) {
            this.backgroundAlpha = prop.getInt();
        } else {
            prop.setValue(this.backgroundAlpha);
        }
        prop = config.get("Prefix", "Chroma", false);
        if (load) {
            this.prefixChroma = prop.getBoolean();
        } else {
            prop.setValue(this.prefixChroma);
        }
        prop = config.get("Prefix", "PrefixStyle", 0);
        if (load) {
            this.prefixStyle = prop.getInt();
        } else {
            prop.setValue(this.prefixStyle);
        }
        prop = config.get("Prefix", "Color", -1);
        if (load) {
            this.prefixColor = prop.getInt();
        } else {
            prop.setValue(this.prefixColor);
        }
        prop = config.get("Coordinates", "Chroma", false);
        if (load) {
            this.textChroma = prop.getBoolean();
        } else {
            prop.setValue(this.textChroma);
        }
        prop = config.get("Coordinates", "Color", -1);
        if (load) {
            this.textColor = prop.getInt();
        } else {
            prop.setValue(this.textColor);
        }
        prop = config.get("Direction", "Chroma", false);
        if (load) {
            this.directionChroma = prop.getBoolean();
        } else {
            prop.setValue(this.directionChroma);
        }
        prop = config.get("Direction", "Color", -1);
        if (load) {
            this.directionColor = prop.getInt();
        } else {
            prop.setValue(this.directionColor);
        }
        prop = config.get("Direction", "ShowSkinFace", true);
        if (load) {
            this.skinFaceDirection = prop.getBoolean();
        } else {
            prop.setValue(this.skinFaceDirection);
        }
        prop = config.get("Biome", "Chroma", false);
        if (load) {
            this.biomeNameChroma = prop.getBoolean();
        } else {
            prop.setValue(this.biomeNameChroma);
        }
        prop = config.get("Biome", "Color", -1);
        if (load) {
            this.biomeNameColor = prop.getInt();
        } else {
            prop.setValue(this.biomeNameColor);
        }
    }
}

